#include "SDL.h"
#include "sprig.h"
#include "Animation.h"
#include "SDL_image.h"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;
extern SDL_Surface* screen;

ASAnimation::ASAnimation(char* infoFile, float Speed)
{
    w = 0;
    h = 0;
    speed = Speed;
    
    numLoops = -1;

    loadAnim(infoFile);

    blitRect.x = 0;
    blitRect.y = 0;
    blitRect.w = w;
    blitRect.h = h;

    lastUpdate = -1;

    pause = false;
    currentFrame = 0;

    pauseTime = 0;
    randimate = false;



}

ASAnimation::ASAnimation(const vector<ASFrame>& Frames, float Speed)
{
    w = 0;
    h = 0;
    speed = Speed;
    
    frame = Frames;
    
    numLoops = -1;

    for (unsigned int i = 0; i < frame.size(); i++)
    {
        // Get max values of w and h
        w = w < frame[i].pic->w? frame[i].pic->w : w;
        h = h < frame[i].pic->h? frame[i].pic->h : h;
    }


    blitRect.x = 0;
    blitRect.y = 0;
    blitRect.w = w;
    blitRect.h = h;

    lastUpdate = -1;

    pause = false;
    currentFrame = 0;

    pauseTime = 0;
    randimate = false;

}

void ASAnimation::loadAnim(char* infoFile)
{
    int numFrames = 0;
    w = 0;
    h = 0;

    // Read infoFile
    ifstream f;
    f.open(infoFile);
    if (f.fail())
    {
        cerr << "File not found: " << infoFile << endl;
        return;
    }

    while (!f.eof())
    {
        char* line = new char[80];
        for (int i = 0; i < 80; i++)
            line[i] = '\0';

        f.getline(line, 80);

        for (int i = 0; i < 79; i++)
        {
            if (line[i] == ' ' || line[i] == '\n' || line[i] == '\t')
                continue;
            if ((line[i] == '/' && line[i+1] == '/') || line[i] == '\0')
                break;

            numFrames++;
            break;
        }
        delete[] line;

    }
    f.close();


    //cout << numFrames << endl;

    f.clear();
    f.open(infoFile);

    string* picFile = new string[numFrames];
    int* delay = new int[numFrames];

    int picNum = 0;
    int counter = numFrames;
    while (!f.eof() && counter > 0)
    {
        char* line = new char[80];
        for (int i = 0; i < 80; i++)
            line[i] = ' ';

        f.getline(line, 80);

        bool reading = 0;
        bool getDelay = 0;

        string reader;

        //cout << "Checking the line" << endl;
        for (int i = 0; i < 79; i++)
        {
            if (!reading && (line[i] == ' ' || line[i] == '\n' || line[i] == '\t'))
                continue;
            if ((line[i] == '/' && line[i+1] == '/'))
                break;

            reading = 1;

            //cout << reader << endl;

            if (!getDelay && (line[i] == ' ' || line[i] == '\n' || line[i] == '\t'))
            {
                //cout << "PicFile result: " << reader << endl;
                char* temp = new char[80];
                strcpy(temp, reader.c_str());
                //cout << "PicNum = " << picNum << endl;
                picFile[picNum] = temp;

                reader.clear();
                //cout << "PicFile result: " << picFile[picNum] << endl;
                getDelay = 1;
                reading = 0;
                continue;
            }

            if (getDelay && (line[i] == ' ' || line[i] == '\n' || line[i] == '\t'))
            {
                //cout << "Delay result: " << reader << endl;
                //cout << "PicNum = " << picNum << endl;
                delay[picNum++] = atoi(reader.c_str());
                //cout << "PicNum = " << picNum << endl;
                reader.clear();

                counter--;
                break;
            }

            reader += line[i];
        }
        //cout << "Done checking line" << endl;
        getDelay = 0;
        reading = 0;
        //delete[] line;
        reader.clear();


    }
    f.close();


    /*cout << "PicNum = " << picNum << endl;
    for(int i = 0; i < numFrames; i++)
    {
        cout << "i = " << i << endl;
        cout << picFile[i] << endl << delay[i] << endl << endl;
      
    }*/

    string info = infoFile;

    int slash = info.find_last_of('/', info.length());
    int backslash = info.find_last_of('\\', info.length());

    int numChars = slash > backslash? slash : backslash;

    if (numChars < 0) numChars = 0;

    string path = info.substr(0, numChars + 1);
    //cout << path << endl;

    // Load up the frames now
    frame.clear();

    // Init the array
    for (int i = 0; i < numFrames; i++)
    {
        frame.push_back(ASFrame(IMG_Load((path + picFile[i]).c_str()), delay[i]));

        if (frame[i].pic == NULL)
            cerr << endl << "Error loading frame " << i << " from " << path + picFile[i] << endl;
        else
        {
            // Set up that mean, mean alpha.
            SDL_Surface* source = frame[i].pic;
            //SDL_SetAlpha(source, SDL_SRCALPHA, 0);
            SDL_Surface* temp = SDL_DisplayFormatAlpha(source);
            SDL_FreeSurface(source);
            frame[i].pic = temp;
            //SDL_SetAlpha(source, SDL_SRCALPHA, 0);
            /*
            SDL_Surface* temp = SDL_CreateRGBSurface(SDL_SWSURFACE, source->w, source->h, 32, 0xFF000000, 0x00FF0000, 0x0000FF00, 0);
            SDL_BlitSurface(source, NULL, temp, NULL);
            SDL_FreeSurface(source);  // Both source and pic are deleted here.
            frame[i].pic = temp;*/
            // Get max values of w and h
            w = w < frame[i].pic->w? frame[i].pic->w : w;
            h = h < frame[i].pic->h? frame[i].pic->h : h;
        }
    }



    blitRect.x = 0;
    blitRect.y = 0;
    blitRect.w = w;
    blitRect.h = h;

    lastUpdate = -1;

    pause = 0;
    currentFrame = 0;

    pauseTime = 0;




}

void ASAnimation::loadAnim(const vector<ASFrame>& Frames)
{
    w = 0;
    h = 0;

    frame = Frames;

    for (unsigned int i = 0; i < frame.size(); i++)
    {
        // Get max values of w and h
        w = w < frame[i].pic->w? frame[i].pic->w : w;
        h = h < frame[i].pic->h? frame[i].pic->h : h;
    }


    blitRect.x = 0;
    blitRect.y = 0;
    blitRect.w = w;
    blitRect.h = h;

    lastUpdate = -1;

    pause = 0;
    currentFrame = 0;

    pauseTime = 0;

}

int ASAnimation::draw(SDL_Surface* dest, float X, float Y)
{
    if (!pause)
    {
        if(lastUpdate < 0)
        {
            lastUpdate = SDL_GetTicks();
        }
        else
        {
            int timeOverDelay = int((int(SDL_GetTicks()) - lastUpdate) * speed) - frame[currentFrame].delay;
            //cout << "TOD = " << timeOverDelay << endl;
            if(randimate)
            {
                if(timeOverDelay > 0)
                {
                    lastUpdate = SDL_GetTicks();// + timeOverDelay;
                    currentFrame = rand()%frame.size();
                    timeOverDelay = 0;
                }
            }
            while(timeOverDelay > 0)
            {
                // Last update is the new time plus the over time
                lastUpdate = SDL_GetTicks();// + timeOverDelay;
                
                // Change timeOverDelay and loop to cause frameskip
                timeOverDelay -= frame[currentFrame].delay + 1;
                
                currentFrame++;
                
                
                if (currentFrame >= int(frame.size()))
                {
                    currentFrame = 0;
                    if(numLoops > 0)
                        numLoops--;
                    if(numLoops == 0)
                    {
                        drawn = 1;
                        stop();
                        reset();
                        return 0;
                    }
                }
                // Change timeOverDelay and loop to cause frameskip
                //timeOverDelay -= frame[currentFrame].delay;
                // This doesn't seem right, since this is a new frame, not the one you're skipping.
                
            }
            
        }


    }

    drawn = 1;


    blitRect.x = (int)X;
    blitRect.y = (int)Y;
    
    //cout << blitRect.x << ", " << blitRect.y << ": " << currentFrame << " - " << (frame[currentFrame].pic == NULL) << endl;
    
    SDL_BlitSurface(frame[currentFrame].pic, NULL, dest, &blitRect);
    //SDL_BlitSurface(frame[0].pic, NULL, screen, NULL);
    
    return numLoops;
}

int ASAnimation::drawCenter(SDL_Surface* dest, float X, float Y)
{
    if (!pause)
    {
        if(lastUpdate < 0)
        {
            lastUpdate = SDL_GetTicks();
        }
        else
        {
            int timeOverDelay = int((int(SDL_GetTicks()) - lastUpdate) * speed) - frame[currentFrame].delay;
            //cout << "TOD = " << timeOverDelay << endl;
            if(randimate)
            {
                if(timeOverDelay > 0)
                {
                    lastUpdate = SDL_GetTicks();// + timeOverDelay;
                    currentFrame = rand()%frame.size();
                    timeOverDelay = 0;
                }
            }
            while(timeOverDelay > 0)
            {
                // Last update is the new time plus the over time
                lastUpdate = SDL_GetTicks();// + timeOverDelay;
                
                // Change timeOverDelay and loop to cause frameskip
                timeOverDelay -= frame[currentFrame].delay + 1;
                
                currentFrame++;
                
                
                if (currentFrame >= int(frame.size()))
                {
                    currentFrame = 0;
                    if(numLoops > 0)
                        numLoops--;
                    if(numLoops == 0)
                    {
                        drawn = 1;
                        stop();
                        reset();
                        return 0;
                    }
                }
                // Change timeOverDelay and loop to cause frameskip
                //timeOverDelay -= frame[currentFrame].delay;
                // This doesn't seem right, since this is a new frame, not the one you're skipping.
                
            }
            
        }


    }

    drawn = 1;


    blitRect.x = (int)(X - frame[currentFrame].pic->w/2);
    blitRect.y = (int)(Y - frame[currentFrame].pic->h/2);
    
    //cout << blitRect.x << ", " << blitRect.y << ": " << currentFrame << " - " << (frame[currentFrame].pic == NULL) << endl;
    
    SDL_BlitSurface(frame[currentFrame].pic, NULL, dest, &blitRect);
    //SDL_BlitSurface(frame[0].pic, NULL, screen, NULL);
    
    return numLoops;
}

int ASAnimation::drawRotated(SDL_Surface* dest, float X, float Y, float degrees)
{
    if (!pause)
    {
        if(lastUpdate < 0)
        {
            lastUpdate = SDL_GetTicks();
        }
        else
        {
            int timeOverDelay = int((int(SDL_GetTicks()) - lastUpdate) * speed) - frame[currentFrame].delay;
            //cout << "TOD = " << timeOverDelay << endl;
            if(randimate)
            {
                if(timeOverDelay > 0)
                {
                    lastUpdate = SDL_GetTicks();// + timeOverDelay;
                    currentFrame = rand()%frame.size();
                    timeOverDelay = 0;
                }
            }
            
            while(timeOverDelay > 0)
            {
            // Last update is the new time plus the over time
            lastUpdate = SDL_GetTicks();// + timeOverDelay;
                
                // Change timeOverDelay and loop to cause frameskip
                timeOverDelay -= frame[currentFrame].delay;
                
                currentFrame++;
                
                
                if (currentFrame >= int(frame.size()))
                {
                    currentFrame = 0;
                    if(numLoops > 0)
                        numLoops--;
                    if(numLoops == 0)
                    {
                        drawn = 1;
                        stop();
                        reset();
                        return 0;
                    }
                }
                
                
            }
        }


    }

    drawn = 1;


    blitRect.x = (int)X;
    blitRect.y = (int)Y;
    
    //cout << blitRect.x << ", " << blitRect.y << ": " << currentFrame << " - " << (frame[currentFrame].pic == NULL) << endl;
    
    //SDL_Surface* rotated = SPG_Transform(frame[currentFrame].pic, 0x00000000, degrees, 1, 1, SPG_TAA);
    SDL_Surface* rotated = SPG_RotateAA(frame[currentFrame].pic, 0x00000000, degrees);
    SDL_BlitSurface(rotated, NULL, dest, &blitRect);
    SDL_FreeSurface(rotated);
    
    return numLoops;
}


int ASAnimation::drawRotatedCenter(SDL_Surface* dest, float X, float Y, float degrees)
{
    if (!pause)
    {
        if(lastUpdate < 0)
        {
            lastUpdate = SDL_GetTicks();
        }
        else
        {
            int timeOverDelay = int((int(SDL_GetTicks()) - lastUpdate) * speed) - frame[currentFrame].delay;
            //cout << "TOD = " << timeOverDelay << endl;
            if(randimate)
            {
                if(timeOverDelay > 0)
                {
                    lastUpdate = SDL_GetTicks();// + timeOverDelay;
                    currentFrame = rand()%frame.size();
                    timeOverDelay = 0;
                }
            }
            
            while(timeOverDelay > 0)
            {
            // Last update is the new time plus the over time
            lastUpdate = SDL_GetTicks();// + timeOverDelay;
                
                // Change timeOverDelay and loop to cause frameskip
                timeOverDelay -= frame[currentFrame].delay;
                
                currentFrame++;
                
                
                if (currentFrame >= int(frame.size()))
                {
                    currentFrame = 0;
                    if(numLoops > 0)
                        numLoops--;
                    if(numLoops == 0)
                    {
                        drawn = 1;
                        stop();
                        reset();
                        return 0;
                    }
                }
                
                
            }
        }


    }

    drawn = 1;


    
    //cout << blitRect.x << ", " << blitRect.y << ": " << currentFrame << " - " << (frame[currentFrame].pic == NULL) << endl;
    
    //SDL_Surface* rotated = SPG_Transform(frame[currentFrame].pic, 0x00000000, degrees, 1, 1, SPG_TAA);
    SDL_Surface* rotated = SPG_RotateAA(frame[currentFrame].pic, 0x00000000, degrees);
    
    blitRect.x = (int)X - rotated->w/2;
    blitRect.y = (int)Y - rotated->h/2;
    SDL_BlitSurface(rotated, NULL, dest, &blitRect);
    SDL_FreeSurface(rotated);
    
    return numLoops;
}


int ASAnimation::drawScaled(SDL_Surface* dest, float X, float Y, float scale)
{
    if (!pause)
    {
        if(lastUpdate < 0)
        {
            lastUpdate = SDL_GetTicks();
        }
        else
        {
            int timeOverDelay = int((int(SDL_GetTicks()) - lastUpdate) * speed) - frame[currentFrame].delay;
            //cout << "TOD = " << timeOverDelay << endl;
            if(randimate)
            {
                if(timeOverDelay > 0)
                {
                    lastUpdate = SDL_GetTicks();// + timeOverDelay;
                    currentFrame = rand()%frame.size();
                    timeOverDelay = 0;
                }
            }
            while(timeOverDelay > 0)
            {
                // Last update is the new time plus the over time
                lastUpdate = SDL_GetTicks();// + timeOverDelay;
                
                // Change timeOverDelay and loop to cause frameskip
                timeOverDelay -= frame[currentFrame].delay + 1;
                
                currentFrame++;
                
                
                if (currentFrame >= int(frame.size()))
                {
                    currentFrame = 0;
                    if(numLoops > 0)
                        numLoops--;
                    if(numLoops == 0)
                    {
                        drawn = 1;
                        stop();
                        reset();
                        return 0;
                    }
                }
                // Change timeOverDelay and loop to cause frameskip
                //timeOverDelay -= frame[currentFrame].delay;
                // This doesn't seem right, since this is a new frame, not the one you're skipping.
                
            }
            
        }


    }

    drawn = 1;

    if(frame[currentFrame].pic != NULL)
    {
        blitRect.x = (int)X;
        blitRect.y = (int)Y;
        
        //cout << blitRect.x << ", " << blitRect.y << ": " << currentFrame << " - " << (frame[currentFrame].pic == NULL) << endl;
        
        SDL_Surface* s = SPG_Scale(frame[currentFrame].pic, scale, scale);
        SDL_BlitSurface(s, NULL, dest, &blitRect);
        SDL_FreeSurface(s);
    }
    //SDL_BlitSurface(frame[0].pic, NULL, screen, NULL);
    
    return numLoops;
}

int ASAnimation::drawScaledCenter(SDL_Surface* dest, float X, float Y, float scale)
{
    if (!pause)
    {
        if(lastUpdate < 0)
        {
            lastUpdate = SDL_GetTicks();
        }
        else
        {
            int timeOverDelay = int((int(SDL_GetTicks()) - lastUpdate) * speed) - frame[currentFrame].delay;
            //cout << "TOD = " << timeOverDelay << endl;
            if(randimate)
            {
                if(timeOverDelay > 0)
                {
                    lastUpdate = SDL_GetTicks();// + timeOverDelay;
                    currentFrame = rand()%frame.size();
                    timeOverDelay = 0;
                }
            }
            while(timeOverDelay > 0)
            {
                // Last update is the new time plus the over time
                lastUpdate = SDL_GetTicks();// + timeOverDelay;
                
                // Change timeOverDelay and loop to cause frameskip
                timeOverDelay -= frame[currentFrame].delay + 1;
                
                currentFrame++;
                
                
                if (currentFrame >= int(frame.size()))
                {
                    currentFrame = 0;
                    if(numLoops > 0)
                        numLoops--;
                    if(numLoops == 0)
                    {
                        drawn = 1;
                        stop();
                        reset();
                        return 0;
                    }
                }
                // Change timeOverDelay and loop to cause frameskip
                //timeOverDelay -= frame[currentFrame].delay;
                // This doesn't seem right, since this is a new frame, not the one you're skipping.
                
            }
            
        }


    }

    drawn = 1;


    
    //cout << blitRect.x << ", " << blitRect.y << ": " << currentFrame << " - " << (frame[currentFrame].pic == NULL) << endl;
    if(frame[currentFrame].pic != NULL)
    {
        SDL_Surface* s = SPG_Scale(frame[currentFrame].pic, scale, scale);
        blitRect.x = (int)(X - s->w/2);
        blitRect.y = (int)(Y - s->h/2);
        SDL_BlitSurface(s, NULL, dest, &blitRect);
        SDL_FreeSurface(s);
    }
    //SDL_BlitSurface(frame[0].pic, NULL, screen, NULL);
    
    return numLoops;
}

